% Function: This is the program that takes the complicated hit cell array
% for replicate comparisons and uses the consistency analysis in order to
% identify and troublshoot certain IP/Probe combinations that have 
% difference across replicates. Program exports the information 
% from the complicated hit array into a simplified format

% Inputs:
% RepHitCell - a complicated cell array that contains information about the
%    identity, number, matrix index of the replicate comparison for hits
%    that are different across replicates
% ExpNum - a numerical value for the number of experiments performed (this
%    can also be used to look at the permutations for a subset of the
%    experiments by using a smaller value)
% CombNum - a numerical value that determines the which permutation of the
%    experiments will be used (default is 1, unless measuring hits from a
%    subset of the experiments) 
% NumUnions - a numerical value that determines the consistency level
%    desired, where the number of unions represents the number of
%    experiments a pair can be non-significant 
%    (ie consistent in 3 of 4 or 4 of 4, will have NumUnions = 2)

% Outputs:
% SimpleBadId - the identities of the IP/Probe combinations that are deemed 
%    consistently variable across experimental condition replicates
% SimpleBadIndex - the indices of the IP/Probe combinations that are deemed 
%    consistently variable across experimental condition replicates

function [SimpleBadId,SimpleBadIndex] = SimpleHitsBadPPI(...
    RepHitCell,ExpNum,CombNum,NumUnions)

SimpleBadId = {};
SimpleBadIndex = [];

for i = 1:length(RepHitCell)
    
    SimpleBadIdi = RepHitCell{i}{1}{ExpNum}{CombNum}{NumUnions};
    SimpleBadIndexi = RepHitCell{i}{2}{ExpNum}{CombNum}{NumUnions};
    
    SimpleBadId = union(SimpleBadId,SimpleBadIdi);
    SimpleBadIndex = union(SimpleBadIndex,SimpleBadIndexi);
    
end